import React from 'react';
import './index.less'

const Index = (props) => {
    const {data, list, onClick} = props;
    return (
        <div className="address-box">
            {data && data.length > 0 && data.map((item, index) => (
                <div key={index} className="good-item">
                    <div className="address-item address-title" onClick={() => onClick(item.BGYPMC)}>
                        {list.length > 0 && list[0].showName}：{list.length > 0 && item[list[0].colName]}
                        {/*{list[0] && list[0].showName}：{item[list[0].showName] || ''}*/}
                        <img src="/img/rarrow.png" alt="" className={`icon18 ${item.checked ? 'icon-checked' : 'icon-unchecked'}`}/>
                    </div>
                    { item.checked && (
                        <div>
                            {list.length > 1 && list.map((child, index2) => index2 > 0 && (
                                <div key={index2} className="address-item address-title">
                                    {child.showName}：{item[child.colName] || ''}
                                </div>
                            ))}
                        </div>
                    )}

                </div>
            ))}
        </div>
    );
};

export default Index;
