import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import ParentAddress from '../../components/AddressList/ParentAddress';
import ChildAddress from '../../components/AddressList/ChildAddress';
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import './index.less'
import Empty from '../Empty'
import {WhiteSpace} from "antd-mobile";


const NewPage = (props) => {
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);

    const {pId, HASUSER, parent} = props.match.params;

    useEffect(() => {
        setLoading(true);
        // console.log(HASUSER)
        axiosRequest({
            method: 'post',
            url: HASUSER === 'true' ? `/idtAppServiceV6/oApp/getDeptUserList?deptId=${pId}` :`/idtAppServiceV6/oApp/getChildDeptList?pId=${pId}`,
        }).then(res => {
            setLoading(false);
            setData(res)
        });
    }, [pId]);


    const moveParent = (pId, HASUSER, name) => {
        const next = parent + ',' + name;
        props.history.push(`/bord/address/${pId}/${HASUSER}/${next}`)
    };

    const [title, setTitle] = useState([]);
    useEffect(() => {
        setTitle(parent.split(','))
    }, [parent])

    return (
        <Document title="通讯录">
            <div>
                <div className="communicate-title">
                    {title.map((item, index) => (
                        <span key={index} className={index === 0 ? 'title-common title-select' : 'title-common'}>{item} {index !== title.length -1 && '>'}</span>
                    ))}
                </div>
                <WhiteSpace/>
                <div className='adMainBox'>
                    {loading ? <Skeleton/> : ( data.length > 0 ? (
                        HASUSER === 'true' ? <ChildAddress data={data}/> :<ParentAddress data={data} onClick={moveParent}/>
                    ): <Empty/>)}

                </div>
            </div>

        </Document>
    );
};

export default NewPage;

