import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import ParentAddress from '../../components/AddressList/ParentAddress';
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import './index.less'
import Empty from '../Empty'


const AddressBook = (props) => {
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);

    useEffect(() => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getChildDeptList',
        }).then(res => {
            setLoading(false);
            setData(res)
        });
    }, []);

    const moveParent = (pId, HASUSER, parent) => {
        props.history.push(`/bord/address/${pId}/${HASUSER}/${parent}`)
    }

    return (
        <Document title="通讯录">
            <div>
                <div className='adMainBox'>
                    {loading ? <Skeleton/> : ( data.length > 0 ? (
                        <ParentAddress data={data} onClick={moveParent}/>
                    ): <Empty/>)}

                </div>
            </div>

        </Document>
    );
};

export default AddressBook;

