import React, {useState, useEffect} from 'react';
import {WhiteSpace, WingBlank} from 'antd-mobile'
import TodoCard from '../../components/Card/LogCard'
import TopSearch from '../../components/TopSearch';
import Skeleton from '../../components/Skeleton'
import Loading from '../../components/Loading'
import axiosRequest from '../../utils/request';
import Document from 'react-document-title'
import Empty from '../Empty'
import './index.less'

const Backlog = (props) => {
    const [start, setStart] = useState(true);
    const [end, setEnd] = useState(true)

    useEffect(() => {
        //回到顶部
        window.scrollTo(0, 0)
        getData()
    }, [])
    const [current, setCurrent] = useState(0);
    const [searchWord, setSearchWord] = useState();
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);

    const checkLog = (OPERATEID, UUID, FLOWTBID) => {
        props.history.push(`/blank/info/${OPERATEID}/${UUID}/${FLOWTBID}`)
    };
    const getData = (scroll) => {
        const pageMap ={searchWord, nowPage: current + 1, pageSize: 10};
        setLoading(true);
        scroll && current > 0 && window.scrollTo(0, document.body.scrollHeight);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getWaitDealList',
            body: pageMap,
        }).then(res => {
            setStart(false);
            setEnd(res.dataList && res.dataList.length >= 10)
            let result = end && res.dataList ? data.concat(res.dataList) : data;
            res.dataList && res.dataList.length >= 10 && setCurrent(current + 1);
            current > 0 && res.dataList && res.dataList.length === 0 && setCurrent(current - 1);
            setData(result);
            setLoading(false);
        });
    };

    //下拉加载
    const handleScroll =() => {
        let scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
        let clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        let scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
        if(scrollHeight > clientHeight && scrollTop + clientHeight >= scrollHeight) {
            getData(true)
        }
    }
    useEffect(() => {
        window.addEventListener('touchend', handleScroll, true);
        return () =>  window.removeEventListener('touchend', handleScroll, true);
    }, [data]);

    const wordSearch = val => {
        setCurrent(0)
        setSearchWord(val);
    };
    useEffect(() => {
        setStart(true);
        setData([])
        !start && getData()
    }, [searchWord]);

    return (
        <Document title="待办">
            <WingBlank>
               <div className="notice-box-content">
                   <WhiteSpace/>
                   <TopSearch onSearch={wordSearch}/>
                   <WhiteSpace/>
                   {start ? <div> <WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/></div> : (!start && (
                       data.length > 0 ? data.map((item, index) => (
                           <div key={index}>
                               <WhiteSpace/>
                               <TodoCard data={item} onClick={() => checkLog(item.WD_OPERATE_ID, item.WD_UUID, item.WD_FLOWTBID)}/>
                           </div>

                       )) : <Empty/>
                   ))}

                   <WhiteSpace/>
                   {loading && (
                       <div className="pos-line content-loading">
                           <Loading/>
                           <WhiteSpace/>
                           <WhiteSpace/>
                       </div>
                   )}
                   {!loading && !end && data.length > 0 && (
                       <div className="extra-content">
                           <div className="content-end">
                               ——————  我是有底线的  ——————
                           </div>
                       </div>
                   )}
               </div>

            </WingBlank>
        </Document>
    );
};

export default Backlog;
