import React, {useState, useEffect} from 'react';
import './index.less'
import CardItem from './CardItem'

const Index = (props) => {
    const {title, type, addStatus, addCommon, data, iconAction, workUrl} = props;

    const [card, setCard] = useState([]);
    useEffect(() => {
        const result = [...data]
        const emptyIcon = type === 'edit' ? {
            text: addStatus ? '完成添加' :'添加常用', icon: addStatus ? '/img/finish-work.png' : '/img/add-work.png', iconAdd: true
        } : {};
        const empty = data.length % 3;
        // empty === 0 && result.push(emptyIcon, {}, {});
        empty === 1 && result.push(emptyIcon, {});
        empty === 2 && result.push(emptyIcon);
        setCard(result)
    }, [data])

    return data.length > 0 && (
        <div>
            <div className="work-card-title">
                {title}
            </div>
            <div className="work-card-body">
                {card.map((item, index) => (
                    <CardItem
                        type={type}
                        key={index}
                        data={item}
                        workUrl={workUrl}
                        addStatus={addStatus}
                        addCommon={addCommon}
                        iconAction={iconAction}
                    />
                ))}

            </div>
        </div>
    );
};

export default Index;




