import React, {useState, useEffect} from 'react';
import './index.less'

const CardItem = (props) => {
    const {data, addStatus, type, addCommon, iconAction, workUrl} = props;

    const [status, setStatus] = useState(false);
    useEffect(() => {
        setStatus(addStatus)
    }, [addStatus])

    const contentCLick = () => {
        !status && !data.iconAdd && (data.text !== '内部邮局' && data.text !== '个人日程' && data.text !== '办公用品采购' && data.text !== '') && workUrl(`/blank/work/${data.id}/${data.text}`);
        !status && !data.iconAdd && data.text === '内部邮局' && workUrl(`/blank/mail`);
        !status && !data.iconAdd && data.text === '个人日程' && workUrl(`/blank/date`);
        !status && !data.iconAdd && data.text === '办公用品采购' && workUrl(`/blank/work/${data.id}/${data.text}?type=application`);
        // !status && !data.iconAdd && data.text === '会议申请' && workUrl(`/blank/work/${data.id}/${data.text}`);
        data.iconAdd && addCommon()
    };
    const iconClick = () => {
        iconAction()
    };
    return (
        <div className="card-content" onClick={data.id && data.text && contentCLick}>
            {data.text && (
                <div className="card-content-box">
                    <div className="card-content-img">
                        {
                            status && !data.iconAdd && (
                                <img
                                    src={type === 'edit' ? '/img/common-d.png' : '/img/common-a.png'}
                                    className="card-content-img-icon"
                                    alt=""
                                    onClick={iconClick}
                                />
                            )
                        }


                        <img src={data.icon ? `/img/icon/${data.icon}.png` : "/img/add-work.png"} className="card-content-img-svg" alt="" />
                    </div>
                    <div className="card-content-title">
                        {data.text}
                    </div>
                </div>
            )}
        </div>
    );
};

export default CardItem;
