import React from 'react';
import moment from 'moment'
import './index.less'

const Index = (props) => {
    const {data} = props;
    return (
        <div className="mail-card" onClick={() => props.onClick(data.UUID)}>
            <div className="mail-item mail-title">
                {data.TITLE}
            </div>
            <div className="mail-item mail-label">
                <span>发件人：</span>
                <span>{data.SEND_NAME}</span>
            </div>
            <div className="mail-item mail-label">
                <span>时间：</span>
                <span>{data.SEND_TIME ? moment(data.SEND_TIME).format("YYYY-MM-DD HH:mm:ss") : ''}</span>
            </div>
        </div>
    );
};

export default Index;
