import React, {useState} from 'react';
import {Icon, Popover} from "antd-mobile";
import './index.less'
const Item = Popover.Item;

const MailA = (props) => {
    const {onDelete, data} = props;
    const [visible, setVisible] = useState(false);

    const visibleChange = (visible) => {
        setVisible(visible)
    };
    const onSelect = (val) => {
        onDelete(data.uid);
        visibleChange(false)
    };
    // console.log(data.type.indexOf('image') > -1)

    return (
        <div>
            <div className={`adjunct-card ${data.type.indexOf('image') > -1 ? 'adjunct-pdf' : 'adjunct-word'}`}>
                <div className="adjunct-title">
                    <img alt="" src={data.type.indexOf('image') > -1 ? '/img/test/pdf.png' : '/img/test/word.png'} className="adjunct-img"/>
                    <div className="adjunct-content">
                        <p className="adjunct-title-1">{data.name}</p>
                    </div>
                </div>
                <Popover
                    mask
                    visible={visible}
                    overlay={[
                        (<Item key="4" value="scan">删除</Item>),
                    ]}
                    onVisibleChange={visibleChange}
                    onSelect={onSelect}
                >
                    <Icon type="ellipsis" className="adjunct-icon" size="xxs"/>
                </Popover>

            </div>
        </div>
    );
};

export default MailA;
