import React from 'react';
import './index.less'

const ParentAddress = (props) => {
    const {data, onClick} = props;
    // console.log(data)
    return (
        <div className="address-box">
            {data && data.length > 0 && data.map((item, index) => (
                <div key={index}>
                    <div onClick={() => onClick(item.ID, item.HASUSER, item.NAME)} className="address-item address-title">
                        {item.NAME || ''}
                        <img src="/img/rarrow.png" alt="" className={`icon18 ${item.checked ? 'icon-checked' : 'icon-unchecked'}`}/>
                    </div>
                </div>
            ))}
        </div>
    );
};

export default ParentAddress;
