import React from 'react';
import './index.less'

const ChildAddress = props => {
    const {data} = props;
    return (
        <div className="address-item-box">
            {data && data.length > 0 && data.map((item, index) => (
                <div className="address-item" key={index}>
                    <div>
                        {item.XM || item.xm || ''}
                    </div>
                    <div className="address-user">
                        <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                        <a className="address-phone" href={(item.YDDH || item.yddh)  ? `tel:${item.YDDH}` : null}>{item.YDDH || item.yddh || '无'}</a>
                    </div>
                </div>
            ))}
        </div>
    )
};

export default ChildAddress;
