import React from 'react';
import {Checkbox, List} from 'antd-mobile'
import './index.less'
const Item = Checkbox.CheckboxItem

const Index = (props) => {
    const {data, setName} = props;
    return (
        <div className="address-box">
            <List>
                {data && data.length > 0 && data.map((item, index) => item.XM ? (
                    <Item key={index} className="sub-checkbox" onChange={(val) => setName(item, val.target.checked)}>
                        {item.XM || ''}
                        <div className="address-user">
                            <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                            {item.YDDH || '无'}
                        </div>
                    </Item>
                ) : <div key={index} className="sub-title">{item.DEPTNAME}</div>)}
            </List>

        </div>
    );
};

export default Index;
