import React, {useEffect, useState} from 'react';
import {ActivityIndicator, Toast, WhiteSpace, WingBlank} from 'antd-mobile'
import TodoCard from '../../components/LogCard'
import TopNotice from '../../components/NoticeTab'
import axiosRequest from '../../utils/request';
import './index.less'
import Empty from '../Empty'
// import useDebounce from '../../useHooks/useDebounce'

const WorkDetail = (props) => {
    const [start, setStart] = useState(true);
    useEffect(() => {
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getUnDone',
            body: {nowPage: 1, pageSize: 10},
        }).then(res => {
            setLoading(false);
            setStart(false)
            let result = end && res.rows ? data.concat(res.rows) : data;
            res.rows && res.rows.length >= 10 && setCurrent(1);
            setEnd(res.rows && res.rows.length >= 10)
            setData(result);
        });
    }, [])
    const [current, setCurrent] = useState(0);
    const [searchWord, setSearchWord] = useState();

    const [loading, setLoading] = useState(false);

    const [data, setData] = useState([]);

    const getData = () => {
        const pageMap ={searchWord, nowPage: current + 1, pageSize: 10};
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getUnDone',
            body: pageMap,
        }).then(res => {
            setLoading(false);
            let result = end && res.rows ? data.concat(res.rows) : data;
            res.rows && res.rows.length >= 10 ? setCurrent(current + 1) : Toast.info('当前是最后一页', 1);
            setEnd(res.rows && res.rows.length >= 10)
            setData(result);
        });
    };

    //下拉加载
    const [end, setEnd] = useState(true)
    const handleScroll = () => {
        let scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
        let clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        let scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;

        if(scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
            getData()
        }
    }
    useEffect(() => {
        window.addEventListener('touchend', handleScroll, true);
        return () =>  window.removeEventListener('touchend', handleScroll, true);
    }, [data]);

    const checkLog = () => {
        props.history.push(`/blank/info/example/1`)
    };

    //回到顶部
    useEffect(() => {
        const element = document.getElementById('work-content')
        element.scrollTo(0, 0)
    }, []);

    //tab已读未读切换
    const [tab, setTab] = useState('N');
    const tabData = () => {
        const pageMap ={searchWord, nowPage: current + 1, pageSize: 10, FLAG: tab};
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getUnDone',
            body: pageMap,
        }).then(res => {
            setLoading(false);
            let result = end && res.rows ? [].concat(res.rows) : [];
            res.rows && res.rows.length >= 10 ? setCurrent(current + 1) : Toast.info('当前是最后一页', 1);
            setEnd(res.rows && res.rows.length >= 10)
            setData(result);
        });
    };
    const tabChange = val => {
        setTab(val);
        tabData()
    };

    useEffect(() => {
        getData()
    }, [searchWord, tab])
    return (
        <div id="work-content" className="work-content">
            <WingBlank>
                <ActivityIndicator
                    toast
                    text="加载中..."
                    animating={loading}
                />
                <WhiteSpace/>
                <TopNotice onSearch={setSearchWord} tabChange={tabChange}/>
                {
                    !start && (
                        data.length > 0 ? data.map((item, index) => (
                            <div key={index}>
                                <WhiteSpace/>
                                <TodoCard data={item} onClick={checkLog}/>
                            </div>

                        )) : <Empty/>
                    )

                }
            </WingBlank>
        </div>
    );
};

export default WorkDetail;

