import React, { useState, useEffect } from 'react';
import {WhiteSpace, WingBlank} from "antd-mobile";
// import axiosRequest from '../../utils/request';
import TopSearch from '../../components/TopSearch'
import WorkCard from '../../components/WorkCard';
import Skeleton from '../../components/Skeleton'
import Document from 'react-document-title'
import Empty from '../Empty'

const Work = (props) => {
    const [start, setStart] = useState(true);
    const [loading, setLoading] = useState(false)
    const [addStatus, setAddStatus] = useState(false);
    const [operates, setOperates] = useState([]);
    const [data, setData] = useState([])

    useEffect(() => {
        loadOperates();
    }, []);

    const loadOperates = () => {
        setLoading(true);
        setTimeout(() => {
            setLoading(false)
        }, 1000)
        const res = localStorage.getItem("menu");
        setStart(false);
        const result = JSON.parse(res)
        setOperates(result);
        setData(result);

        // let ss = []
        // JSON.parse(res).map(item => ss.push(item.text));
        // let a = new Set(ss)
        // console.log([...a].join(','))
        // axiosRequest({
        //     method: 'post',
        //     url: '/idtAppServiceV6/oApp/getAllOperate',
        // }).then(res => {
        //     setLoading(false);
        //
        // });
    }

    const commonEdit = () => {
        setAddStatus(!addStatus);
    };

    const workSearch = (val) => {
        const result = operates.filter(item => item.text && item.text.toLowerCase().indexOf(val.toLowerCase()) > -1);
        if (val !== null && val !== '') {
            setData(result)
        }else {
            setData(operates)
        }
    };

    const itemAdd = (id, arr, arr2) => {
        // const item = arr2.filter(item => item.id === id);
        // arr.splice(arr.length - 1, 0, item[0]);
    };

    // const itemSlice = (id, arr, arr2) => {
    //     // const index = arr.findIndex(item => item.id == id);
    //     // index > -1 && arr.splice(index, 1);
    // };

    const workUrl = (url) => {
        // props.history.push(url)
    }

    return (
        <Document title="工作">
            <WingBlank>
                <WhiteSpace/>
                <TopSearch onSearch={ workSearch }/>
                <WhiteSpace/>
                {loading ? <Skeleton/> : (!start && (data.length > 0 ? (
                    <WorkCard
                        title="工作详情"
                        addCommon={ commonEdit }
                        addStatus={addStatus}
                        data={data}
                        workUrl={workUrl}
                        iconAction={ itemAdd }
                    />
                ) : <Empty/>))}
            </WingBlank>
        </Document>
    );
}


export default Work;

