import React, {useEffect, useState} from 'react';
import {WhiteSpace, WingBlank} from 'antd-mobile'
import TodoCard from '../../components/LogCard'
import TopNotice from '../../components/NoticeTab'
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import Document from 'react-document-title'
import Empty from '../Empty'
import Loading from "../../components/Loading";

const Notice = (props) => {
    const [start, setStart] = useState(true);
    const [end, setEnd] = useState(true)

    const [current, setCurrent] = useState(0);
    const [searchWord, setSearchWord] = useState();

    const [loading, setLoading] = useState(false);

    const [data, setData] = useState([]);

    const getData = (scroll) => {
        const pageMap ={searchWord, nowPage: current + 1, pageSize: 10, FLAG: tab};
        setLoading(true);
        scroll && current > 0 && window.scrollTo(0, document.body.scrollHeight)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getUnDone',
            body: pageMap,
        }).then(res => {
            setStart(false);
            setEnd(res.rows && res.rows.length >= 10)
            let result = end && res.rows ? data.concat(res.rows) : data;

            console.log('end', end, 'result',result, 'res', res)
            res.rows && res.rows.length >= 10 && setCurrent(1);
            setData(result);
            setLoading(false);
        });
    };

    //下拉加载
    const handleScroll = () => {
        let scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
        let clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        let scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
        // alert(`${scrollTop} ${clientHeight} ${scrollHeight} ${scrollTop + clientHeight >= scrollHeight}`)

        if(scrollHeight > clientHeight && scrollTop + clientHeight >= scrollHeight) {
            getData(true)
        }
    }
    useEffect(() => {
        window.addEventListener('touchend', handleScroll, true);
        return () =>  window.removeEventListener('touchend', handleScroll, true);
    }, [data]);

    const checkLog = (OPERATEID, UUID) => {
        props.history.push(`/blank/info/${OPERATEID}/${UUID}`)
    };

    //回到顶部
    useEffect(() => {
       window.scrollTo(0, 0)
    }, []);

    //tab已读未读切换
    const [tab, setTab] = useState('N');
    const tabChange = val => {
        setCurrent(0);
        setData([]);
        setTab(val);
        setEnd(true)
    };
    const tabSearch = val => {
        setCurrent(0);
        setData([])
        setSearchWord(val)
        setEnd(true)
    }
    useEffect(() => {
        //回到顶部
        window.scrollTo(0, 0)
        getData()
    }, [])
    useEffect(() => {
        setStart(true);
        getData(false, [])
    }, [searchWord, tab]);


     console.log(data.length)
    return (
        <Document title="通知">
            <WingBlank>
                <WhiteSpace/>
                <TopNotice onSearch={tabSearch} tabChange={tabChange}/>
                { start ? <div> <WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/></div> : ( !start && (
                    data.length > 0 ? data.map((item, index) => (
                        <div key={index}>
                            <WhiteSpace/>
                            <TodoCard data={item} onClick={() => checkLog(item.OPERATEID, item.UUID)}/>
                        </div>

                    )) : <Empty/>
                ))}
                <WhiteSpace/>
                {loading && (
                    <div className="pos-line content-loading">
                        <Loading/>
                        <WhiteSpace/>
                        <WhiteSpace/>
                    </div>
                )}
                {!loading && !end && data.length > 0 && (
                    <div className="content-end">
                        ——————  我是有底线的  ——————
                    </div>
                )}

            </WingBlank>
        </Document>
    );
};

export default Notice;

