import React, {useEffect, useState} from 'react';
// import {WingBlank, WhiteSpace, ActivityIndicator} from "antd-mobile";
import axiosRequest from '../../utils/request';
import AddressCheckbox from '../../components/AddressList/AddressCheckbox';

const SubmitDetail = (props) => {
    const [data, setData] = useState([]);
    // const [title, setTitle] = useState([]);
    const [disabled, setDisabled] = useState(true);
    useEffect(() => {
        const {type} = props.match.params
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/getLeaders?nType=${type}`,
        }).then(res => {
            setData(res)
        });

    }, []);

    const [suData, setSuData] = useState([])
    const checkName = (name, checked) => {
        const newData = [...suData];
        const index = newData.indexOf(name);
        checked ? newData.push(name) : newData.splice(index, 1);
        newData.length > 0 ? setDisabled(false) : setDisabled(true)
        setSuData(newData)
    }

    const textClick = () => {
        console.log(suData)
    }
    return (
        <div>
            <div className='adMainBox'>
                <AddressCheckbox data={data} setName={checkName}/>
            </div>
            <div className="event-footer">
                <div className={`event-footer-button ${(disabled) ? 'button-disabled' : '' }`} onClick={textClick}>
                    {suData.length > 0 ?`（${suData.length}）` : null} 确认发送
                </div>

            </div>
        </div>
    );
};

export default SubmitDetail;
