import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import {WingBlank, WhiteSpace, ActionSheet} from 'antd-mobile'
import axiosRequest from '../../utils/request';
import TopTabs from '../../components/BlankTabs'
import Skeleton from '../../components/Skeleton'
import Basic from './Basic'
import Adjunct from './Adjunct'
import Flow from './Flow';
import Option from './Option';

import './index.less'

const Process = (props) => {
    const {uuid} = props.match.params;

    const [templateId, setTemplateId] = useState();
    const [tableId, setTableId] = useState();
    const [nodeId, setNodeId] = useState();
    const [operateId, setOperateId] = useState()

    //回到顶部
    useEffect(() => {
        window.scrollTo(0, 0)
    }, []);

    useEffect(() => {
        const {id} = props.match.params
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/dispatcher?operateId=${id}&formType=form`,
        }).then(res => {
            const keys = res.elementList ? Object.keys(res.elementList) : []
            setBasic(res.elementList ? keys.map(item => ({title: item})) : [])
            setTableId(res.table && res.table.tableId);
            setTemplateId(res.property && res.property.templateId)
            setNodeId(res.property && res.property.curNodeId)
            setOperateId(res.property && res.property.operateId)
        });

    }, []);
    //获取basic数据
    const [basic, setBasic] = useState([]);
    const [basicLoading, setBasicLoading] = useState(false)
    const getBasic = uuid => {
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/getData`,
            body: {uuid, tableId, templateId}
        }).then(res => {
            setBasicLoading(true)
            const result = [...basic];
            result.map(item => {
                item.content = res[item.title]
                return null;
            });
            setBasic(result)
        });
    }
    //获取Flow数据
    const [flowData, setFlowData] = useState([]);
    const [flowLoading, setFlowLoading] = useState(false)
    const getFlow = uuid => {
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/getFlowList`,
            body: {uuid, tableId}
        }).then(res => {
            setFlowLoading(true)
            setFlowData(res)
        });
    };

    const [adjunctData, setAdjunctData] = useState([]);
    const [adjunctLoading, setAdjunctLoading] = useState(false)
    const getAdjunct= uuid => {
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/getFiles`,
            body: {uuid, fieldName: 'fj', tableId}
        }).then(res => {
            setAdjunctLoading(true)
            setAdjunctData(res)
        });
    };
    const [button, setButton] = useState([])
    const getButton= uuid => {
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/nextNodeList`,
            body: {curNodeId: nodeId}
        }).then(res => {
            const result = res ? res.map(item => ({button: item.name, target: item.special})) : []
            setButton(result)
        });
    };
    useEffect(() => {
        const {uuid} = props.match.params;
        templateId && tableId && getBasic(uuid)
        templateId && tableId && getFlow(uuid);
        templateId && tableId && getAdjunct(uuid)
        getButton()
    }, [nodeId]);

    //提交按钮状态
    const [disabled, setDisabled] = useState(true);
    //提交按钮文字
    const [footButton, setFootButton] = useState('确认发送');
    //聚焦
    const optionBlur = () => {
        setFootButton('确认发送');
        setFootStatus(true)
    };
    useEffect(() => {
        const option = document.getElementsByClassName("option-text")[0];
        if (option) {
            option.addEventListener('focus', optionBlur, true);
            return () => option.removeEventListener('focus', optionBlur, true);
        }
    }, [basic]);

    const [blyj, setBlyj] = useState()
    const optionChange = val => {
        setBlyj(val)
        setDisabled(!(val != null && val !== ''))
    };

    const [current, setCurrent] = useState('basic');
    const [footStatus, setFootStatus] = useState(false);

    //点击输入框， 聚焦移动
    const textClick = () => {
        const top = document.getElementById(`event-option`).offsetTop;
        document.getElementById("event").scrollTo(0,top)
        document.getElementsByClassName("option-text")[0].focus();
        optionBlur()
    };

    //tab切换
    const tabClick = (name) => {
        setCurrent(name)
        name === 'option' && document.getElementsByClassName("option-text")[0].focus();
        name === 'option' && optionBlur()
        const top = document.getElementById(`event-${name}`).offsetTop;
        console.log(top)
        window.scrollTo(0,top);
    };


    //antd-mobile 提交选项
    const isIPhone = new RegExp('\\biPhone\\b|\\biPod\\b', 'i').test(window.navigator.userAgent);
    let wrapProps;
    if (isIPhone) {
        wrapProps = {
            onTouchStart: e => e.preventDefault(),
        };
    };

    const beforeSubmit = () => {
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/save`,
            body: {
                tableId,
                templateId,
                dealInfo: {"BLYJ": blyj},
                params: {uuid},
                curNodeId: nodeId,
                operateId
            }
        }).then(res => {
            console.log(res)
        });
    }

    const showActionSheet = () => {
        const BUTTON = []
        button.map(item => BUTTON.push(item.button));
        const BUTTONS = BUTTON.concat(['取消']);
        ActionSheet.showActionSheetWithOptions({
                options: BUTTONS,
                cancelButtonIndex: BUTTONS.length - 1,
                maskClosable: true,
                wrapProps,
            },
            (buttonIndex) => {
                buttonIndex < BUTTONS.length - 1 && subUrl(buttonIndex)
                console.log(buttonIndex)
            });
    };
    const subUrl = key => {
        beforeSubmit()
        // const url = button[key].target;
        // props.history.push(`/blank/submit/${url}`)
    }

    const handleScroll = () => {
        // const adjunct = document.getElementById("event-adjunct").offsetTop;
        // const flow = document.getElementById("event-flow").offsetTop;
        // const option = document.getElementById("event-option").offsetTop;
        // const event = document.getElementById('event');
        // const top = event.scrollTop;
        // const scrollHeight = event.scrollHeight;
        // const clientHeight = event.clientHeight
        // if (top >= 0 && top < adjunct) {
        //     setCurrent('basic')
        // }else if (top >= adjunct && top < flow) {
        //     setCurrent('adjunct')
        // }else if (top >= flow && top < option) {
        //     setCurrent('flow')
        // }else if (top >= option) {
        //     setCurrent('option')
        // }
        // if (top + clientHeight === scrollHeight) {
        //     setCurrent('option')
        // }
    };
    useEffect(() => {
        window.addEventListener('scroll', handleScroll, true);
        return () =>  window.removeEventListener('scroll', handleScroll, true);
    }, []);

    return (
        <Document title="待办详情">
            <div>
                <TopTabs page={current} onClick={tabClick}/>
                <div id="event">
                    <WingBlank>
                        <div id="event-basic"/>
                        <WhiteSpace/>
                        {basicLoading ?  <Basic data={basic}/> : <Skeleton/>}
                        <div id="event-adjunct"/>
                        <WhiteSpace/>
                        {adjunctLoading ? <Adjunct data={adjunctData}/> : <Skeleton/>}
                        <div id="event-flow"/>
                        <WhiteSpace/>
                        {flowLoading ? <Flow data={flowData}/> : <Skeleton/>}
                        <div id="event-option"/>
                        <WhiteSpace/>
                        {basicLoading ? <Option onChange={optionChange}/> : <Skeleton/>}

                    </WingBlank>
                </div>
                <div className="event-footer">
                    <div className={`event-footer-button ${(footStatus && disabled) ? 'button-disabled' : '' }`} onClick={footStatus && !disabled ? showActionSheet: textClick}>
                        {!footStatus && (
                            <img alt="" src="/img/process-edit.png" className="process-edit"/>
                        )}
                        {footButton}
                    </div>

                </div>

            </div>
        </Document>
    );
};

export default Process;
