import React, {useState, useEffect} from 'react';
import {WhiteSpace} from 'antd-mobile'
import AddressUser from '../../components/AddressList/AddressUser';
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import Document from 'react-document-title'
import Empty from '../Empty'


const Communicate = (props) => {
    const [start, setStart] = useState(true);
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);
    const [title, setTitle] = useState([])

    const getData = (id) => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/oApp/getSearchAddressBook?deptId=${id}`,
        }).then(res => {
            setLoading(false);
            setStart(false)
            setData(res.userList)
            setTitle(res.deptList)
        });
    };
    useEffect(() => {
        const {id} = props.match.params;
        getData(id)
    }, []);


    return (
        <Document title="通讯录">
            <div>
                <div className='breadBox'>
                    {title && title.length > 0 ? title[0].depts : ''}
                </div>
                {loading ? <div><WhiteSpace/><Skeleton/></div> : (
                    <div className='adMainBox'>
                        { data && !start && (data.length > 0 ?  <AddressUser data={data}/> : <Empty/>)}
                    </div>
                )}
            </div>

        </Document>
    );
};

export default Communicate;

