import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import AddressList from '../../components/AddressList';
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import './index.less'
import Empty from '../Empty'


const AddressBook = (props) => {
    const [start, setStart] = useState(true);
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);
    // const [type, setType] = useState('basic')

    // const {id} = props.match.params;

    // console.log(id, ss);

    const getData = () => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getDeptTree',
        }).then(res => {
            setStart(false)
            setLoading(false);
            setData(res)
        });
    };
    useEffect(() => {
        getData()
    }, []);

    const treeClick = (val) => {
        props.history.push(`/bord/address/${val}`)
    };
    return (
        <Document title="通讯录">
            <div>
                <div className='adMainBox'>
                    {loading ? <Skeleton/> : (!start && ( data.length > 0 ? (
                        <AddressList data={data} onCLick={treeClick}/>
                    ): <Empty/>))}

                </div>
            </div>

        </Document>
    );
};

export default AddressBook;

