import React, {useState, useEffect} from 'react';
import './index.less'

const CardItem = (props) => {
    const {data, addStatus, type, addCommon, iconAction, workUrl} = props;

    const [status, setStatus] = useState(false);
    useEffect(() => {
        setStatus(addStatus)
    }, [addStatus])

    const contentCLick = () => {
        !status && !data.iconAdd && data.text && workUrl('/blank/work/1')
        data.iconAdd && addCommon()
    };
    const iconClick = () => {
        iconAction()
    };
    return (
        <div className="card-content" onClick={contentCLick}>
            {data.text && (
                <div className="card-content-box">
                    <div className="card-content-img">
                        {
                            status && !data.iconAdd && (
                                <img
                                    src={type === 'edit' ? '/img/common-d.png' : '/img/common-a.png'}
                                    className="card-content-img-icon"
                                    alt=""
                                    onClick={iconClick}
                                />
                            )
                        }


                        <img src={data.icon ? `/img/icon/${data.icon}.png` : "/img/add-work.png"} className="card-content-img-svg" alt="" />
                    </div>
                    <div className="card-content-title">
                        {data.text}
                    </div>
                </div>
            )}
        </div>
    );
};

export default CardItem;
