import React from 'react';
import {Checkbox, List} from 'antd-mobile'
import './index.less'
const Item = Checkbox.CheckboxItem

const Index = (props) => {
    const {data, setName} = props;
    return (
        <div className="address-box">
            <List>
                {data && data.length > 0 && data.map((item, index) => (
                  <div>
                      <div className="sub-title">
                          {item.DEPTNAME}
                      </div>
                      {item.childrenUser && item.childrenUser.map((child, index) => (
                          <Item key={child.XM} className="sub-checkbox" onChange={(val) => setName(child.XM, val.target.checked)}>
                              {child.XM || ''}
                              <div className="address-user">
                                  <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                                  {child.YDDH || '无'}
                              </div>
                          </Item>
                      ))}
                  </div>
                ))}
            </List>

        </div>
    );
};

export default Index;
